/*
 * Decompiled with CFR 0.152.
 */
package dev.quarris.ppfluids.items;

import de.ellpeck.prettypipes.items.IModule;
import de.ellpeck.prettypipes.items.ModuleTier;
import de.ellpeck.prettypipes.misc.DirectionSelector;
import de.ellpeck.prettypipes.pipe.PipeBlockEntity;
import de.ellpeck.prettypipes.pipe.containers.AbstractPipeContainer;
import dev.quarris.ppfluids.ModContent;
import dev.quarris.ppfluids.container.FluidRetrievalModuleContainer;
import dev.quarris.ppfluids.items.FluidItem;
import dev.quarris.ppfluids.items.FluidModuleItem;
import dev.quarris.ppfluids.items.IFluidFilterProvider;
import dev.quarris.ppfluids.misc.FluidDirectionSelector;
import dev.quarris.ppfluids.misc.FluidFilter;
import dev.quarris.ppfluids.pipe.FluidPipeBlockEntity;
import dev.quarris.ppfluids.pipenetwork.FluidNetworkLocation;
import dev.quarris.ppfluids.pipenetwork.PipeNetworkUtil;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.apache.commons.lang3.tuple.Pair;

public class FluidRetrievalModuleItem
extends FluidModuleItem
implements IFluidFilterProvider {
    private final int maxExtraction;
    private final int speed;
    private final boolean preventOversending;
    public final int filterSlots;

    public FluidRetrievalModuleItem(String name, ModuleTier tier) {
        super(name);
        this.maxExtraction = (Integer)tier.forTier((Object)500, (Object)2000, (Object)8000);
        this.speed = (Integer)tier.forTier((Object)40, (Object)20, (Object)10);
        this.filterSlots = (Integer)tier.forTier((Object)2, (Object)4, (Object)8);
        this.preventOversending = (Boolean)tier.forTier((Object)true, (Object)true, (Object)true);
    }

    public void tick(ItemStack module, PipeBlockEntity tile) {
        FluidPipeBlockEntity fluidPipe;
        block5: {
            block4: {
                if (!(tile instanceof FluidPipeBlockEntity)) break block4;
                fluidPipe = (FluidPipeBlockEntity)tile;
                if (tile.shouldWorkNow(this.speed) && tile.canWork()) break block5;
            }
            return;
        }
        Direction[] directions = this.getDirectionSelector(module, tile).directions();
        block0: for (FluidFilter subFilter : fluidPipe.getFluidFilters()) {
            for (int slot = 0; slot < subFilter.getSlots(); ++slot) {
                Optional filtered;
                ItemStack filteredBucket = subFilter.getStackInSlot(slot);
                if (filteredBucket.m_41619_() || !(filtered = FluidUtil.getFluidContained((ItemStack)filteredBucket)).isPresent()) continue;
                FluidStack copy = ((FluidStack)filtered.get()).copy();
                copy.setAmount(this.maxExtraction);
                Pair<BlockPos, ItemStack> dest = fluidPipe.getAvailableDestination(directions, copy, true, this.preventOversending);
                if (dest == null) continue;
                ItemStack fluidItem = ((ItemStack)dest.getRight()).m_41777_();
                if (PipeNetworkUtil.requestFluid(fluidPipe.m_58904_(), fluidPipe.m_58899_(), (BlockPos)dest.getLeft(), FluidItem.getFluidCopyFromItem(fluidItem)).isEmpty()) continue block0;
            }
        }
    }

    private FluidStack requestFilteredFromNetwork(Level level, BlockPos pos, FluidFilter filter) {
        for (FluidNetworkLocation location : PipeNetworkUtil.getOrderedNetworkFluids(level, pos)) {
            FluidStack fluid = location.getFirstAvailableFluid(level);
            if (!filter.isPipeFluidAllowed(fluid)) continue;
            return fluid;
        }
        return FluidStack.EMPTY;
    }

    @Override
    public boolean canNetworkSee(ItemStack module, PipeBlockEntity pipe, Direction dir, IFluidHandler destination) {
        return false;
    }

    @Override
    public boolean canAcceptItem(ItemStack module, PipeBlockEntity pipe, ItemStack stack, Direction dir, IFluidHandler destination) {
        return false;
    }

    @Override
    public boolean isCompatible(ItemStack module, PipeBlockEntity tile, IModule other) {
        return tile instanceof FluidPipeBlockEntity && !(other instanceof FluidRetrievalModuleItem);
    }

    @Override
    public boolean hasContainer(ItemStack module, PipeBlockEntity tile) {
        return tile instanceof FluidPipeBlockEntity;
    }

    public AbstractPipeContainer<?> getContainer(ItemStack module, PipeBlockEntity tile, int windowId, Inventory inv, Player player, int moduleIndex) {
        return new FluidRetrievalModuleContainer((MenuType)ModContent.FLUID_RETRIEVAL_CONTAINER.get(), windowId, player, tile.m_58899_(), moduleIndex);
    }

    public DirectionSelector getDirectionSelector(ItemStack module, PipeBlockEntity tile) {
        return new FluidDirectionSelector(module, tile);
    }

    @Override
    public FluidFilter getFluidFilter(ItemStack module, FluidPipeBlockEntity tile) {
        FluidFilter filter = new FluidFilter(this.filterSlots, module, tile, true);
        return filter;
    }
}

